# 🕹️ Proyecto Pelos — Juego 2D con Godot 4

Este proyecto está basado en el tutorial oficial de Godot [“Tu primer juego 2D”](https://docs.godotengine.org/es/4.x/getting_started/first_2d_game/index.html#prerequisites), al cual se le han añadido varias mejoras como:

- Sistema de **vidas** y **recuperación**.
- Escena **informativa** adicional.
- Sonidos personalizados para **golpes, recuperación y game over**.

---

## 📂 Estructura del proyecto para empezar

├── Sound
│ ├── House In a Forest Loop.ogg
│ ├── combat-punch-hit-a.mp3
│ ├── gameover.wav
│ └── sfx-magic12.mp3
├── art
│ ├── Mob
│ │ ├── enemyFlyingAlt_1.png
│ │ ├── enemyFlyingAlt_2.png
│ │ ├── enemySwimming_1.png
│ │ ├── enemySwimming_2.png
│ │ ├── enemyWalking_1.png
│ │ └── enemyWalking_2.png
│ ├── Pelos
│ │ ├── playerGrey_up1.png
│ │ ├── playerGrey_up2.png
│ │ ├── playerGrey_walk1.png
│ │ └── playerGrey_walk2.png
│ └── Pociones
│ ├── PocionTipo1.png
│ └── PocionTipo2.png
└── fonts
└── Xolonium-Regular.ttf


---

## 🧙‍♂️ Recursos utilizados

### 🎨 Arte y sprites
- **Tutorial base:**  
  [Documentación oficial de Godot — Tu primer juego 2D](https://docs.godotengine.org/es/4.x/getting_started/first_2d_game/index.html#prerequisites)

- **Pociones:**  
  [artist2d3d.itch.io/pociones-2d](https://artist2d3d.itch.io/pociones-2d)

### 🔊 Sonidos
- **Efectos de golpe, magia y game over:**  
  Archivos obtenidos de páginas de audio gratuito en internet.

---

## 💾 Repositorio

Proyecto completo disponible en GitHub:  
👉 [https://github.com/Jhon-mantila/proyecto_pelos](https://github.com/Jhon-mantila/proyecto_pelos)

---

## 🌐 Sitios relacionados
- [esquinaweb.com](https://esquinaweb.com) — Tecnología, creatividad y desarrollo.  
- [esquinagamers.com](https://esquinagamers.com) — Videojuegos, reseñas y guías.

---

## 👤 Autor

**Jhon Edinson Mantilla Ruiz**  
Desarrollador y creador de contenido.  
📧 Proyecto colaborativo inspirado en la documentación oficial de Godot.
